<?php
require_once 'config/database.php';

try {
    $pdo = getDB();

    // Create exams table
    $pdo->exec("
        CREATE TABLE IF NOT EXISTS exams (
            id INT AUTO_INCREMENT PRIMARY KEY,
            title VARCHAR(255) NOT NULL,
            slug VARCHAR(255) UNIQUE NOT NULL,
            description LONGTEXT,
            short_description TEXT,
            course_id INT NULL,
            instructor_id INT NOT NULL,
            total_points DECIMAL(5,2) DEFAULT 0.00,
            passing_score DECIMAL(5,2) DEFAULT 60.00,
            duration_minutes INT DEFAULT 60,
            max_attempts INT DEFAULT 3,
            price DECIMAL(10,2) DEFAULT 0.00,
            currency VARCHAR(3) DEFAULT 'USD',
            is_free BOOLEAN DEFAULT TRUE,
            status ENUM('draft', 'published', 'archived') DEFAULT 'draft',
            instructions TEXT,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            FOREIGN KEY (course_id) REFERENCES courses(id) ON DELETE SET NULL,
            FOREIGN KEY (instructor_id) REFERENCES users(id) ON DELETE CASCADE,
            INDEX idx_course (course_id),
            INDEX idx_instructor (instructor_id),
            INDEX idx_status (status)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
    ");

    echo "Exams migration applied successfully.";
} catch (PDOException $e) {
    echo "Error applying exams migration: " . $e->getMessage();
}
?>